/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.curses;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnBreakSpeed;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnEquipmentChanged;
import com.mlib.contexts.OnItemSwingDuration;
import com.mlib.contexts.OnUseItemTick;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.enchantment.DiggingEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class FatigueCurse
extends CustomEnchantment {
    public FatigueCurse() {
        this.rarity(Enchantment.Rarity.RARE).category(EnchantmentCategory.BREAKABLE).slots(EquipmentSlots.ALL).curse().maxLevel(3).minLevelCost(level -> 10).maxLevelCost(level -> 50);
    }

    public boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof DiggingEnchantment) && super.m_5975_(enchantment);
    }

    @AutoInstance
    public static class Handler {
        static final Range<Double> MULTIPLIER_RANGE = new Range((Number)0.1, (Number)0.99);
        static final AttributeHandler ATTACK_SPEED_ATTRIBUTE = new AttributeHandler("3f350b5c-4b00-4fbb-8381-c1af0749f779", "FatigueAttackSpeed", Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        static final AttributeHandler MOVEMENT_SPEED_ATTRIBUTE = new AttributeHandler("760f7b82-76c7-4875-821e-ef0579b881e0", "FatigueMovementSpeed", Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        final DoubleConfig miningMultiplier = new DoubleConfig(0.8, MULTIPLIER_RANGE);
        final DoubleConfig attackMultiplier = new DoubleConfig(0.8, MULTIPLIER_RANGE);
        final DoubleConfig movementMultiplier = new DoubleConfig(0.95, MULTIPLIER_RANGE);
        final DoubleConfig drawingMultiplier = new DoubleConfig(0.8, MULTIPLIER_RANGE);
        final DoubleConfig swingMultiplier = new DoubleConfig(0.8, MULTIPLIER_RANGE);
        final Supplier<FatigueCurse> enchantment = Registries.FATIGUE;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.CURSE).name("Fatigue").comment("Effectively reduces the speed of everything.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnBreakSpeed.listen(this::reduceMiningSpeed).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.player)).addConfig((IConfigurable)this.miningMultiplier.name("mining_multiplier").comment("Mining speed multiplier per each level.")).insertTo(group);
            OnEquipmentChanged.listen(this::reduceAttackSpeed).addConfig((IConfigurable)this.attackMultiplier.name("attack_multiplier").comment("Attack speed multiplier per each level.")).insertTo(group);
            OnEquipmentChanged.listen(this::reduceMovementSpeed).addConfig((IConfigurable)this.movementMultiplier.name("movement_multiplier").comment("Movement speed multiplier per each level on armor.")).insertTo(group);
            OnUseItemTick.listen(this::reduceBowstringSpeed).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.entity)).addCondition(Condition.predicate(data -> BowItem.m_40661_((int)(data.itemStack.m_41779_() - data.duration)) > 0.3f)).addCondition(Condition.predicate(data -> Random.tryChance((double)(1.0f - this.getItemMultiplier(this.drawingMultiplier, data.entity))))).addConfig((IConfigurable)this.drawingMultiplier.name("drawing_multiplier").comment("Bowstring speed multiplier per each level.")).insertTo(group);
            OnItemSwingDuration.listen(this::increaseSwingDuration).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.entity)).addConfig((IConfigurable)this.swingMultiplier.name("swing_multiplier").comment("Swing speed multiplier per each level.")).insertTo(group);
        }

        private void reduceMiningSpeed(OnBreakSpeed.Data data) {
            data.newSpeed *= this.getItemMultiplier(this.miningMultiplier, (LivingEntity)data.player);
        }

        private void reduceAttackSpeed(OnEquipmentChanged.Data data) {
            ATTACK_SPEED_ATTRIBUTE.setValue((double)(this.getItemMultiplier(this.attackMultiplier, data.entity) - 1.0f)).apply(data.entity);
        }

        private void reduceMovementSpeed(OnEquipmentChanged.Data data) {
            MOVEMENT_SPEED_ATTRIBUTE.setValue((double)(this.getArmorMultiplier(this.movementMultiplier, data.entity) - 1.0f)).apply(data.entity);
        }

        private void reduceBowstringSpeed(OnUseItemTick.Data data) {
            data.event.setDuration(data.duration + 1);
        }

        private void increaseSwingDuration(OnItemSwingDuration.Data data) {
            data.extraDuration = (int)((float)data.extraDuration + ((float)data.swingDuration / Math.min(1.0f, this.getItemMultiplier(this.swingMultiplier, data.entity)) - (float)data.swingDuration));
        }

        private float getItemMultiplier(DoubleConfig config, LivingEntity entity) {
            return (float)Math.pow((Double)config.get(), this.enchantment.get().getEnchantmentLevel(entity.m_21205_()));
        }

        private float getArmorMultiplier(DoubleConfig config, LivingEntity entity) {
            return (float)Math.pow((Double)config.get(), this.enchantment.get().getEnchantmentSum(entity, EquipmentSlots.ARMOR));
        }
    }
}

